import pyvisa

class USB_Controller:

    def __init__(self, hostname = None):
        self.hostname = hostname
        rm = pyvisa.ResourceManager()
        if self.hostname is None:
            print rm.list_resources()
            self.hostname = raw_input("Enter Device Name: ")
        print "Connecting to Instrument..."
        self.instr = rm.open_resource(self.hostname)
        resp = self.query('*IDN?',verbose=False)
        print resp[:-1]
        print "Instrument Connected"

    def disconnect(self):
        pass

    def command(self, CMD,verbose=False):
        self.instr.write(CMD +'\n')
        if verbose:
            print "Command Sent: " + CMD

    def query(self, CMD, show_response = True, verbose=False):
        if verbose:
            print "Command Sent: " + CMD
            print 'Waiting...'
        out = self.instr.query(CMD)
        return out
